
var regEmail = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;

var oBusyDialogWO = new sap.m.BusyDialog({});
jQuery.sap.require("sap.m.MessageBox");

var oBundle =  jQuery.sap.resources({ url: "i18n/i18n_en.properties" });

function resetPassword(){

  
   var email = document.getElementById("email").value;
    if (regEmail.test(email) == false) {
        sap.m.MessageBox.error(oBundle.getText("Email_Invalid"));
        return ;
     }

   oBusyDialogWO.open();

    firebase.auth().sendPasswordResetEmail(email).then(function() {
  
        sap.m.MessageBox.success("Password reset link sent to your email. Click on link to reset your password.");
        document.getElementById("email").value="";
        oBusyDialogWO.close();
  
  }).catch(function(error) {
   
    var errorCode = error.code;
    var errorMessage = error.message;
   
    if (errorCode == 'auth/invalid-email') {
        oBusyDialogWO.close();
        sap.m.MessageBox.error(errorMessage);
    } else if (errorCode == 'auth/user-not-found') {
        oBusyDialogWO.close();
        sap.m.MessageBox.error(errorMessage);
    }
   
  });
  
} 


